% example6.m
%
% Demonstrates how to run the PSS optimization.
%
% Copyright (©) 2024 The Regents of the University of Colorado, a body
% corporate. Created by Gregory L. Plett and M. Scott Trimboli of the
% University of Colorado Colorado Springs (UCCS). This work is licensed
% under a Creative Commons "Attribution-ShareAlike 4.0 International" Intl.
% License. https://creativecommons.org/licenses/by-sa/4.0/ 
% This code is provided as a supplement to: Gregory L. Plett and M. Scott
% Trimboli, "Battery Management Systems, Volume III, Physics-Based
% Methods," Artech House, 2024. It is provided "as is", without express or
% implied warranty. Attribution should be given by citing: Gregory L. Plett
% and M. Scott Trimboli, Battery Management Systems, Volume III:
% Physics-Based Methods, Artech House, 2024.         

clear; close all; clc;
if(~isdeployed),cd(fileparts(which(mfilename))); end
addpath(genpath('..'));
rng(42); % make results repeatable

% Set output level of toolbox functions.
%outp.quiet;   % warnings and errors only
%outp.normal;  % text output only
outp.verbose; % text and plot output

% Configure debug output of toolbox functions.
outp.debug('off');  % 'on' or 'off'

% Choose cell dataset.
cellspec = labcell('PAN');


% Regress model to lab data -----------------------------------------------
configREG.init.QAh = 'params.const.Q';
configREG.init.psi = 'params.const.psi';
configREG.lb.QAh = '0.9*params.const.Q';
configREG.ub.QAh = '1.1*params.const.Q';
configREG.lb.psi = '0.5*params.const.psi';
configREG.ub.psi = '10*params.const.psi';
configREG.ts = 10;   % simulation sampling interval [s]
fitPSS(cellspec,configREG,'dis','+25degC 0.5C FP41');