% example3.m
%
% Demonstrates how to run the discharge-test optimizations.
%
% Copyright (©) 2024 The Regents of the University of Colorado, a body
% corporate. Created by Gregory L. Plett and M. Scott Trimboli of the
% University of Colorado Colorado Springs (UCCS). This work is licensed
% under a Creative Commons "Attribution-ShareAlike 4.0 International" Intl.
% License. https://creativecommons.org/licenses/by-sa/4.0/ 
% This code is provided as a supplement to: Gregory L. Plett and M. Scott
% Trimboli, "Battery Management Systems, Volume III, Physics-Based
% Methods," Artech House, 2024. It is provided "as is", without express or
% implied warranty. Attribution should be given by citing: Gregory L. Plett
% and M. Scott Trimboli, Battery Management Systems, Volume III:
% Physics-Based Methods, Artech House, 2024.         

clear; close all; clc;
if(~isdeployed),cd(fileparts(which(mfilename))); end
addpath(genpath('..'));
rng(42); % make results repeatable

% Set output level of toolbox functions.
%outp.quiet;   % warnings and errors only
%outp.normal;   % text output only
outp.verbose; % text and plot output

% Configure debug output of toolbox functions.
outp.debug('off');  % 'on' or 'off'

% Choose cell dataset.
cellspec = labcell('PAN');


% Read raw data into MAT files --------------------------------------------
makeMATfileDischg(cellspec);


% Process raw data from MAT files -----------------------------------------
processDischg(cellspec);


% Regress model to lab data -----------------------------------------------
configREG.init.DsrefNEG = 10^(-5);
configREG.init.DsrefPOS = 10^(-5);
configREG.init.mPOS = 0.8;
configREG.init.bPOS = '(params.pos.theta0Tilde+1)/2';
configREG.lb.DsrefNEG = 10^(-7.5);
configREG.lb.DsrefPOS = 10^(-7.5);
configREG.lb.mPOS = 1-0.45;
configREG.lb.bPOS = 'params.pos.theta0Tilde';
configREG.ub.DsrefNEG = 10^(-2.5);
configREG.ub.DsrefPOS = 10^(-2.5);
configREG.ub.mPOS = 1-0.05;
configREG.ub.bPOS = 1;
configREG.pin.bPOS = 1;  % pin the value of the b parameter
configREG.rTildeRef = (0.95)^(1/3); % radius where solid diffus. calculated
                                    % (radius @ 95% volume)
configREG.ts = 6;     % simulation sampling interval [s]
configREG.Np = 100;   % number of particles for PSO
fitDischg(cellspec,configREG,'dis','+25degC 0.5C FP41');
