% example2.m
%
% Demonstrates how to run the OCV optimizations.
%
% Copyright (©) 2024 The Regents of the University of Colorado, a body
% corporate. Created by Gregory L. Plett and M. Scott Trimboli of the
% University of Colorado Colorado Springs (UCCS). This work is licensed
% under a Creative Commons "Attribution-ShareAlike 4.0 International" Intl.
% License. https://creativecommons.org/licenses/by-sa/4.0/ 
% This code is provided as a supplement to: Gregory L. Plett and M. Scott
% Trimboli, "Battery Management Systems, Volume III, Physics-Based
% Methods," Artech House, 2024. It is provided "as is", without express or
% implied warranty. Attribution should be given by citing: Gregory L. Plett
% and M. Scott Trimboli, Battery Management Systems, Volume III:
% Physics-Based Methods, Artech House, 2024.         

clear; close all; clc;
if(~isdeployed),cd(fileparts(which(mfilename))); end
addpath(genpath('..'));

% Set output level of toolbox functions.
%outp.quiet;   % warnings and errors only
%outp.normal;   % text output only
outp.verbose; % text and plot output

% Configure debug output of toolbox functions.
outp.debug('off');  % 'on' or 'off'

% Choose cell dataset.
cellspec = labcell('PAN');


% Read raw data into MAT files --------------------------------------------
makeMATfileOCV(cellspec);


% Process raw data from MAT files -----------------------------------------
processOCV(cellspec);


% Regress composition boundaries to processed data ------------------------
config.vmin = 2.1;
config.vmin = 2.5;
config.vmax = 4.1;
config.init.theta0n = 0.06;
config.init.theta100n = 0.8;
config.init.theta0p = 0.9;
config.init.theta100p = 0.2;
config.optw = 0.1;
config.datype = 'useAvg';
config.daxcorrfiltz = @(Z){
    0.05<Z & Z<0.9  % focus on ranges with "stairs"
};

fitOCV(cellspec,config);