% This example displays a Nyquist plot for the "NMC30" cell. We recommend
% that you experiment by changing the cell for which the plot is generated.
% 
% Copyright (©) 2024 The Regents of the University of Colorado, a body
% corporate. Created by Gregory L. Plett and M. Scott Trimboli of the
% University of Colorado Colorado Springs (UCCS). This work is licensed
% under a Creative Commons "Attribution-ShareAlike 4.0 International" Intl.
% License. https://creativecommons.org/licenses/by-sa/4.0/ 
% This code is provided as a supplement to: Gregory L. Plett and M. Scott
% Trimboli, "Battery Management Systems, Volume III, Physics-Based
% Methods," Artech House, 2024. It is provided "as is", without express or
% implied warranty. Attribution should be given by citing: Gregory L. Plett
% and M. Scott Trimboli, Battery Management Systems, Volume III:
% Physics-Based Methods, Artech House, 2024.         

clearvars; close all; clc;
if(~isdeployed),cd(fileparts(which(mfilename)));end
addpath(genpath('../../TOOLBOX'));

% Change the filename in the next line to display a Nyquist plot for a
% different cell. Cell definitions are stored in the XLSX_CELLDEFS folder.
cellData = loadCellParams('cellNMC30.xlsx');

% Change the value of SOC and T in the next lines to display Bode plots for
% a different state-of-charge and temperature setpoint, respectively
SOC = 0.8;            % Cell state of charge
T = 273.15 + 25;      % Temperature in K for 25 degC
omega = [0, logspace(-6,12,200)]; s = 1j*omega;  
cellData = evalSetpoint(cellData,s,SOC,T);

[phise_tf,~] = tfPhiseInt(s,[0,3],cellData);
[phie_tf,~]  = tfPhie(s,3,cellData);
Z = -(phise_tf(2,:) - phise_tf(1,:) + phie_tf) + cellData.const.Rc;

plot(real(1000*Z),-imag(1000*Z)); 
xlabel('Real'); h = ylabel('-Imag'); title('Impedance (milliohms)');
xlim([0 2]); ylim([0 2]); grid on; axis square; 