% This example displays Bode magnitude and phase plots for the Ifdl
% transfer function for the "NMC30" cell. We recommend that you experiment
% by changing the cell for which the transfer function is plotted, and by
% changing the transfer function that is displayed.
% 
% Copyright (©) 2024 The Regents of the University of Colorado, a body
% corporate. Created by Gregory L. Plett and M. Scott Trimboli of the
% University of Colorado Colorado Springs (UCCS). This work is licensed
% under a Creative Commons "Attribution-ShareAlike 4.0 International" Intl.
% License. https://creativecommons.org/licenses/by-sa/4.0/ 
% This code is provided as a supplement to: Gregory L. Plett and M. Scott
% Trimboli, "Battery Management Systems, Volume III, Physics-Based
% Methods," Artech House, 2024. It is provided "as is", without express or
% implied warranty. Attribution should be given by citing: Gregory L. Plett
% and M. Scott Trimboli, Battery Management Systems, Volume III:
% Physics-Based Methods, Artech House, 2024.         

clearvars; close all; clc;
if(~isdeployed),cd(fileparts(which(mfilename)));end
addpath(genpath('../../TOOLBOX'));

% Change the filename in the next line to display Bode plots for a
% different cell. Cell definitions are stored in the XLSX_CELLDEFS folder.
cellData = loadCellParams('cellNMC30.xlsx');

% Change the value of SOC and T in the next lines to display Bode plots for
% a different state-of-charge and temperature setpoint, respectively
SOC = 0.8;            % Cell state of charge
T = 273.15 + 25;      % Temperature in K for 25 degC
omega = [0, logspace(-4,6,200)]; s = 1j*omega;  
cellData = evalSetpoint(cellData,s,SOC,T);

% Change the name of the transfer function (replace "tfIfdl" with something
% else) to display Bode plots of a different transfer function -- you will
% also want to change the titles on the plots, below
[ifdl_tf,~] = tfIfdl(s,2:0.1:3,cellData);

subplot(2,1,1); semilogx(omega,20*log10(abs(ifdl_tf)));
title('Magnitude response for i:f+dl'); grid on
ylabel('Magnitude (dB)'); xlabel('Frequency (rad/s)');
subplot(2,1,2); semilogx(omega,unwrap(angle(ifdl_tf),[],2)*180/pi);
title('Phase response for i:f+dl'); grid on
ylabel('Phase (deg)'); xlabel('Frequency (rad/s)');